/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.jmdns.tools;

import com.strangeberry.jmdns.tools.Browser;
import com.strangeberry.jmdns.tools.Responder;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Hashtable;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;

public class Main {
    public static void main(String[] argv) throws IOException {
        block20: {
            int argc = argv.length;
            boolean debug = false;
            InetAddress intf = null;
            if (argc > 0 && "-d".equals(argv[0])) {
                System.arraycopy(argv, 1, argv, 0, --argc);
                System.getProperties().put("jmdns.debug", "1");
                debug = true;
            }
            if (argc > 1 && "-i".equals(argv[0])) {
                intf = InetAddress.getByName(argv[1]);
                System.arraycopy(argv, 2, argv, 0, argc -= 2);
            }
            if (intf == null) {
                intf = InetAddress.getLocalHost();
            }
            JmDNS jmdns = new JmDNS(intf);
            if (argc == 0 || argc >= 1 && "-browse".equals(argv[0])) {
                new Browser(jmdns);
                int i = 2;
                while (i < argc) {
                    jmdns.registerServiceType(argv[i]);
                    ++i;
                }
            } else if (argc == 1 && "-bt".equals(argv[0])) {
                jmdns.addServiceTypeListener(new SampleListener());
            } else if (argc == 3 && "-bs".equals(argv[0])) {
                jmdns.addServiceListener(String.valueOf(argv[1]) + "." + argv[2], new SampleListener());
            } else {
                if (argc > 4 && "-rs".equals(argv[0])) {
                    String type = String.valueOf(argv[2]) + "." + argv[3];
                    String name = argv[1];
                    Hashtable<String, String> props = null;
                    int i = 5;
                    while (i < argc) {
                        int j = argv[i].indexOf(61);
                        if (j < 0) {
                            throw new RuntimeException("not key=val: " + argv[i]);
                        }
                        if (props == null) {
                            props = new Hashtable<String, String>();
                        }
                        props.put(argv[i].substring(0, j), argv[i].substring(j + 1));
                        ++i;
                    }
                    jmdns.registerService(new ServiceInfo(type, name, Integer.parseInt(argv[4]), 0, 0, props));
                    while (true) {
                        try {
                            Thread.sleep(Integer.MAX_VALUE);
                        }
                        catch (InterruptedException e) {
                            break block20;
                        }
                    }
                }
                if (argc == 2 && "-f".equals(argv[0])) {
                    new Responder(jmdns, argv[1]);
                } else if (!debug) {
                    System.out.println();
                    System.out.println("jmdns:");
                    System.out.println("     -d                                       - output debugging info");
                    System.out.println("     -i <addr>                                - specify the interface address");
                    System.out.println("     -browse [<type>...]                      - GUI browser (default)");
                    System.out.println("     -bt                                      - browse service types");
                    System.out.println("     -bs <type> <domain>                      - browse services by type");
                    System.out.println("     -rs <name> <type> <domain> <port> <txt>  - register service");
                    System.out.println("     -f <file>                                - rendezvous responder");
                    System.out.println();
                    System.exit(1);
                }
            }
        }
    }

    static class SampleListener
    implements ServiceListener,
    ServiceTypeListener {
        SampleListener() {
        }

        public void serviceAdded(ServiceEvent event) {
            System.out.println("ADD: " + event.getDNS().getServiceInfo(event.getType(), event.getName(), 3000));
        }

        public void serviceRemoved(ServiceEvent event) {
            System.out.println("REMOVE: " + event.getName());
        }

        public void serviceResolved(ServiceEvent event) {
            System.out.println("RESOLVED: " + event.getInfo());
        }

        public void serviceTypeAdded(ServiceEvent event) {
            System.out.println("TYPE: " + event.getType());
        }
    }
}

