/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.rendezvous;

import com.strangeberry.rendezvous.DNSEntry;
import java.util.Iterator;

class DNSCache {
    static final float LOAD_FACTOR = 0.75f;
    DNSEntry[] entries;
    int count;
    float loadFactor;

    DNSCache(int size) {
        size = Math.max(2, size * 2);
        while (size % 2 == 0 || size % 3 == 0 || size % 5 == 0) {
            ++size;
        }
        this.entries = new DNSEntry[size];
    }

    void add(DNSEntry entry) {
        if ((float)this.count >= (float)this.entries.length * 0.75f) {
            this.entries = this.rehash(this.entries, this.entries.length * 2);
        }
        this.add(this.entries, entry);
        ++this.count;
    }

    private void add(DNSEntry[] entries, DNSEntry entry) {
        int i = Math.abs(entry.key.hashCode()) % entries.length;
        while (entries[i] != null) {
            i = (i == 0 ? entries.length : i) - 1;
        }
        entries[i] = entry;
    }

    private DNSEntry[] rehash(DNSEntry[] entries, int size) {
        while (size % 2 == 0 || size % 3 == 0 || size % 5 == 0) {
            ++size;
        }
        DNSEntry[] newentries = new DNSEntry[size];
        int i = 0;
        int n = entries.length;
        while (i < n) {
            if (entries[i] != null) {
                this.add(newentries, entries[i]);
            }
            ++i;
        }
        return newentries;
    }

    boolean remove(DNSEntry entry) {
        int i = Math.abs(entry.key.hashCode()) % this.entries.length;
        DNSEntry e;
        while ((e = this.entries[i]) != null) {
            if (e == entry) {
                this.remove(i);
                return true;
            }
            if (--i >= 0) continue;
            i = this.entries.length - 1;
        }
        return false;
    }

    private void remove(int i) {
        int empty = i;
        this.entries[empty] = null;
        --this.count;
        while (true) {
            DNSEntry e;
            if (--i < 0) {
                i = this.entries.length - 1;
            }
            if ((e = this.entries[i]) == null) {
                return;
            }
            int j = Math.abs(e.key.hashCode()) % this.entries.length;
            if (!(i < empty ? j < i || j >= empty : j < i && j >= empty)) continue;
            this.entries[empty] = e;
            empty = i;
            this.entries[empty] = null;
        }
    }

    DNSEntry get(DNSEntry entry) {
        int i = Math.abs(entry.key.hashCode()) % this.entries.length;
        DNSEntry e;
        while ((e = this.entries[i]) != null) {
            if (e.equals(entry)) {
                return e;
            }
            if (--i >= 0) continue;
            i = this.entries.length - 1;
        }
        return null;
    }

    DNSEntry get(String name, int type, int clazz) {
        String key = name.toLowerCase();
        int i = Math.abs(key.hashCode()) % this.entries.length;
        DNSEntry e;
        while ((e = this.entries[i]) != null) {
            if (key.equals(e.key) && type == e.type && clazz == e.clazz) {
                return e;
            }
            if (--i >= 0) continue;
            i = this.entries.length - 1;
        }
        return null;
    }

    Iterator all() {
        return new IterateAll();
    }

    Iterator find(String name) {
        return new IterateKey(name.toLowerCase());
    }

    void print() {
        Iterator i = this.all();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }

    private class IterateAll
    implements Iterator {
        int index;

        IterateAll() {
            this.index = DNSCache.this.entries.length - 1;
        }

        public boolean hasNext() {
            while (this.index >= 0) {
                if (DNSCache.this.entries[this.index] != null) {
                    return true;
                }
                --this.index;
            }
            return false;
        }

        public Object next() {
            return DNSCache.this.entries[this.index--];
        }

        public void remove() {
            DNSCache.this.remove(++this.index);
        }
    }

    private class IterateKey
    implements Iterator {
        String key;
        int index;

        IterateKey(String key) {
            this.key = key;
            this.index = Math.abs(key.hashCode()) % DNSCache.this.entries.length;
        }

        public boolean hasNext() {
            while (true) {
                DNSEntry e;
                if (this.index < 0) {
                    this.index = DNSCache.this.entries.length - 1;
                }
                if ((e = DNSCache.this.entries[this.index]) == null) {
                    return false;
                }
                if (e.key.equals(this.key)) {
                    return true;
                }
                --this.index;
            }
        }

        public Object next() {
            return DNSCache.this.entries[this.index--];
        }

        public void remove() {
            DNSCache.this.remove(++this.index);
        }
    }
}

