/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.rendezvous;

import com.strangeberry.rendezvous.DNSConstants;
import com.strangeberry.rendezvous.DNSQuestion;
import com.strangeberry.rendezvous.DNSRecord;
import java.io.IOException;
import java.net.DatagramPacket;
import java.util.Enumeration;
import java.util.Vector;

final class DNSIncoming
extends DNSConstants {
    static final Vector EMPTY = new Vector();
    DatagramPacket packet;
    int off;
    int len;
    byte[] data;
    int id;
    int flags;
    int numQuestions;
    int numAnswers;
    int numAuthorities;
    int numAdditionals;
    Vector questions;
    Vector answers;

    DNSIncoming(DatagramPacket packet) throws IOException {
        this.packet = packet;
        this.data = packet.getData();
        this.len = packet.getLength();
        this.off = packet.getOffset();
        this.questions = EMPTY;
        this.answers = EMPTY;
        try {
            int n;
            this.id = this.readUnsignedShort();
            this.flags = this.readUnsignedShort();
            this.numQuestions = this.readUnsignedShort();
            this.numAnswers = this.readUnsignedShort();
            this.numAuthorities = this.readUnsignedShort();
            this.numAdditionals = this.readUnsignedShort();
            if (this.numQuestions > 0) {
                this.questions = new Vector(this.numQuestions);
                int i = 0;
                while (i < this.numQuestions) {
                    DNSQuestion question = new DNSQuestion(this.readName(), this.readUnsignedShort(), this.readUnsignedShort());
                    this.questions.add(question);
                    ++i;
                }
            }
            if ((n = this.numAnswers + this.numAuthorities + this.numAdditionals) > 0) {
                this.answers = new Vector(n);
                int i = 0;
                while (i < n) {
                    String domain = this.readName();
                    int type = this.readUnsignedShort();
                    int clazz = this.readUnsignedShort();
                    int ttl = this.readInt();
                    int len = this.readUnsignedShort();
                    int end = this.off + len;
                    DNSRecord rec = null;
                    switch (type) {
                        case 1: {
                            rec = new DNSRecord.Address(domain, type, clazz, ttl, this.readInt());
                            break;
                        }
                        case 5: 
                        case 12: {
                            rec = new DNSRecord.Pointer(domain, type, clazz, ttl, this.readName());
                            break;
                        }
                        case 16: {
                            rec = new DNSRecord.Text(domain, type, clazz, ttl, this.readBytes(this.off, len));
                            break;
                        }
                        case 33: {
                            rec = new DNSRecord.Service(domain, type, clazz, ttl, this.readUnsignedShort(), this.readUnsignedShort(), this.readUnsignedShort(), this.readName());
                        }
                    }
                    if (rec != null) {
                        this.answers.add(rec);
                    }
                    this.off = end;
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.print(true);
            throw e;
        }
    }

    boolean isQuery() {
        return (this.flags & 0x8000) == 0;
    }

    boolean isResponse() {
        return (this.flags & 0x8000) == 32768;
    }

    int get(int off) throws IOException {
        if (off < 0 || off >= this.len) {
            throw new IOException("parser error: offset=" + off);
        }
        return this.data[off] & 0xFF;
    }

    int readUnsignedShort() throws IOException {
        return (this.get(this.off++) << 8) + this.get(this.off++);
    }

    int readInt() throws IOException {
        return (this.readUnsignedShort() << 16) + this.readUnsignedShort();
    }

    byte[] readBytes(int off, int len) throws IOException {
        byte[] bytes = new byte[len];
        System.arraycopy(this.data, off, bytes, 0, len);
        return bytes;
    }

    void readUTF(StringBuffer buf, int off, int len) throws IOException {
        int end = off + len;
        while (off < end) {
            int ch = this.get(off++);
            switch (ch >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    ch = (ch & 0x1F) << 6 | this.get(off++) & 0x3F;
                    break;
                }
                case 14: {
                    ch = (ch & 0xF) << 12 | (this.get(off++) & 0x3F) << 6 | this.get(off++) & 0x3F;
                    break;
                }
                default: {
                    ch = (ch & 0x3F) << 4 | this.get(off++) & 0xF;
                }
            }
            buf.append((char)ch);
        }
    }

    String readName() throws IOException {
        int len;
        StringBuffer buf = new StringBuffer();
        int off = this.off;
        int next = -1;
        block4: while ((len = this.get(off++)) != 0) {
            switch (len & 0xC0) {
                case 0: {
                    this.readUTF(buf, off, len);
                    off += len;
                    buf.append('.');
                    continue block4;
                }
                case 192: {
                    if (next < 0) {
                        next = off + 1;
                    }
                    off = (len & 0x3F) << 8 | this.get(off++);
                    continue block4;
                }
            }
            throw new IOException("bad domain name: '" + buf + "' at " + off);
        }
        this.off = next >= 0 ? next : off;
        return buf.toString();
    }

    void print(boolean dump) {
        System.out.println(this.toString());
        Enumeration e = this.questions.elements();
        while (e.hasMoreElements()) {
            System.out.println("    " + e.nextElement());
        }
        e = this.answers.elements();
        while (e.hasMoreElements()) {
            System.out.println("    " + e.nextElement());
        }
        if (dump) {
            int off = 0;
            int len = this.packet.getLength();
            while (off < len) {
                int n = Math.min(32, len - off);
                if (off < 10) {
                    System.out.print(' ');
                }
                if (off < 100) {
                    System.out.print(' ');
                }
                System.out.print(off);
                System.out.print(':');
                int i = 0;
                while (i < n) {
                    if (i % 8 == 0) {
                        System.out.print(' ');
                    }
                    System.out.print(Integer.toHexString((this.data[off + i] & 0xF0) >> 4));
                    System.out.print(Integer.toHexString((this.data[off + i] & 0xF) >> 0));
                    ++i;
                }
                System.out.println();
                System.out.print("    ");
                i = 0;
                while (i < n) {
                    if (i % 8 == 0) {
                        System.out.print(' ');
                    }
                    System.out.print(' ');
                    int ch = this.data[off + i] & 0xFF;
                    System.out.print(ch > 32 && ch < 127 ? (char)ch : (char)'.');
                    ++i;
                }
                System.out.println();
                if (off + 32 >= 256) {
                    System.out.println("....");
                    break;
                }
                off += 32;
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.isQuery() ? "dns[query," : "dns[response,");
        buf.append(this.packet.getAddress().getHostAddress());
        buf.append(':');
        buf.append(this.packet.getPort());
        buf.append(",len=" + this.packet.getLength());
        buf.append(",id=0x" + Integer.toHexString(this.id));
        if (this.flags != 0) {
            buf.append(",flags=0x" + Integer.toHexString(this.flags));
            if ((this.flags & 0x8000) != 0) {
                buf.append(":r");
            }
            if ((this.flags & 0x400) != 0) {
                buf.append(":aa");
            }
            if ((this.flags & 0x200) != 0) {
                buf.append(":rc");
            }
        }
        if (this.numQuestions > 0) {
            buf.append(",questions=" + this.numQuestions);
        }
        if (this.numAnswers > 0) {
            buf.append(",answers=" + this.numAnswers);
        }
        if (this.numAuthorities > 0) {
            buf.append(",authorities=" + this.numAuthorities);
        }
        if (this.numAdditionals > 0) {
            buf.append(",additionals=" + this.numAdditionals);
        }
        buf.append("]");
        return buf.toString();
    }
}

