/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.rendezvous;

import com.strangeberry.rendezvous.DNSEntry;
import com.strangeberry.rendezvous.DNSIncoming;
import com.strangeberry.rendezvous.DNSOutgoing;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

abstract class DNSRecord
extends DNSEntry {
    int ttl;
    long created;

    DNSRecord(String name, int type, int clazz, int ttl) {
        super(name, type, clazz);
        this.ttl = ttl;
        this.created = System.currentTimeMillis();
    }

    public boolean equals(Object other) {
        return other instanceof DNSRecord && this.sameAs((DNSRecord)other);
    }

    boolean sameAs(DNSRecord other) {
        return super.equals(other) && this.sameValue(other);
    }

    abstract boolean sameValue(DNSRecord var1);

    boolean suppressedBy(DNSIncoming msg) {
        int i = msg.numAnswers;
        while (i-- > 0) {
            if (!this.suppressedBy((DNSRecord)msg.answers.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    boolean suppressedBy(DNSRecord other) {
        return this.sameAs(other) && other.ttl > this.ttl / 2;
    }

    long getExpirationTime(int percent) {
        return this.created + (long)(percent * this.ttl) * 10L;
    }

    int getRemainingTTL(long now) {
        return (int)Math.max(0L, (this.getExpirationTime(100) - now) / 1000L);
    }

    boolean isExpired(long now) {
        return this.getExpirationTime(100) <= now;
    }

    boolean isStale(long now) {
        return this.getExpirationTime(50) <= now;
    }

    void resetTTL(DNSRecord other) {
        this.created = other.created;
        this.ttl = other.ttl;
    }

    abstract void write(DNSOutgoing var1) throws IOException;

    public String toString(String other) {
        return this.toString("record", String.valueOf(this.ttl) + "/" + this.getRemainingTTL(System.currentTimeMillis()) + "," + other);
    }

    static class Address
    extends DNSRecord {
        int addr;

        Address(String name, int type, int clazz, int ttl, int addr) {
            super(name, type, clazz, ttl);
            this.addr = addr;
        }

        void write(DNSOutgoing out) throws IOException {
            out.writeInt(this.addr);
        }

        boolean sameValue(DNSRecord other) {
            return this.addr == ((Address)other).addr;
        }

        InetAddress getAddress() {
            try {
                return InetAddress.getByName(this.getHostAddress());
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }

        public String getHostAddress() {
            return String.valueOf(this.addr >> 24 & 0xFF) + "." + (this.addr >> 16 & 0xFF) + "." + (this.addr >> 8 & 0xFF) + "." + (this.addr & 0xFF);
        }

        public String toString() {
            return this.toString(this.getHostAddress());
        }
    }

    static class Pointer
    extends DNSRecord {
        String alias;

        Pointer(String name, int type, int clazz, int ttl, String alias) {
            super(name, type, clazz, ttl);
            this.alias = alias;
        }

        void write(DNSOutgoing out) throws IOException {
            out.writeName(this.alias);
        }

        boolean sameValue(DNSRecord other) {
            return this.alias.equals(((Pointer)other).alias);
        }

        public String toString() {
            return this.toString(this.alias);
        }
    }

    static class Text
    extends DNSRecord {
        byte[] text;

        Text(String name, int type, int clazz, int ttl, byte[] text) {
            super(name, type, clazz, ttl);
            this.text = text;
        }

        void write(DNSOutgoing out) throws IOException {
            out.writeBytes(this.text, 0, this.text.length);
        }

        boolean sameValue(DNSRecord other) {
            Text txt = (Text)other;
            if (txt.text.length != this.text.length) {
                return false;
            }
            int i = this.text.length;
            while (i-- > 0) {
                if (txt.text[i] == this.text[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.toString(this.text.length > 10 ? String.valueOf(new String(this.text, 0, 7)) + "..." : new String(this.text));
        }
    }

    static class Service
    extends DNSRecord {
        int priority;
        int weight;
        int port;
        String server;

        Service(String name, int type, int clazz, int ttl, int priority, int weight, int port, String server) {
            super(name, type, clazz, ttl);
            this.priority = priority;
            this.weight = weight;
            this.port = port;
            this.server = server;
        }

        void write(DNSOutgoing out) throws IOException {
            out.writeShort(this.priority);
            out.writeShort(this.weight);
            out.writeShort(this.port);
            out.writeName(this.server);
        }

        boolean sameValue(DNSRecord other) {
            Service s = (Service)other;
            return this.priority == s.priority && this.weight == s.weight && this.port == s.port && this.server.equals(s.server);
        }

        public String toString() {
            return this.toString(String.valueOf(this.server) + ":" + this.port);
        }
    }
}

