/*
 * Decompiled with CFR 0.152.
 */
package com.strangeberry.rendezvous;

import com.strangeberry.rendezvous.DNSConstants;
import com.strangeberry.rendezvous.DNSOutgoing;
import com.strangeberry.rendezvous.DNSQuestion;
import com.strangeberry.rendezvous.DNSRecord;
import com.strangeberry.rendezvous.Rendezvous;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ServiceInfo
extends Rendezvous.Listener {
    public static final byte[] NO_VALUE = new byte[0];
    String type;
    String name;
    String server;
    int port;
    int weight;
    int priority;
    byte[] text;
    Hashtable props;
    InetAddress addr;

    public ServiceInfo(String type, String name, InetAddress addr, int port, int weight, int priority, String text) {
        this(type, name, addr, port, weight, priority, (byte[])null);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(text.length());
            this.writeUTF(out, text);
            this.text = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception: " + e);
        }
    }

    public ServiceInfo(String type, String name, InetAddress addr, int port, int weight, int priority, Hashtable props) {
        this(type, name, addr, port, weight, priority, (byte[])null);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(256);
            Enumeration e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object val = props.get(key);
                ByteArrayOutputStream out2 = new ByteArrayOutputStream(100);
                this.writeUTF(out2, key);
                if (val instanceof String) {
                    out2.write(61);
                    this.writeUTF(out2, (String)val);
                } else if (val instanceof byte[]) {
                    out2.write(61);
                    byte[] bval = (byte[])val;
                    out2.write(bval, 0, bval.length);
                } else if (val != NO_VALUE) {
                    throw new IllegalArgumentException("invalid property value: " + val);
                }
                byte[] data = out2.toByteArray();
                out.write(data.length);
                out.write(data, 0, data.length);
            }
            this.text = out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception: " + e);
        }
    }

    public ServiceInfo(String type, String name, InetAddress addr, int port, int weight, int priority, byte[] text) {
        this.type = type;
        this.name = name;
        this.port = port;
        this.weight = weight;
        this.priority = priority;
        this.server = name;
        this.text = text;
        this.addr = addr;
    }

    ServiceInfo(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        if (this.type != null && this.name.endsWith("." + this.type)) {
            return this.name.substring(0, this.name.length() - (this.type.length() + 1));
        }
        return this.name;
    }

    public String getAddress() {
        byte[] data = this.addr.getAddress();
        return String.valueOf(data[0] & 0xFF) + "." + (data[1] & 0xFF) + "." + (data[2] & 0xFF) + "." + (data[3] & 0xFF);
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public byte[] getTextBytes() {
        return this.text;
    }

    public String getTextString() {
        if (this.text == null || this.text.length == 0 || this.text.length == 1 && this.text[0] == 0) {
            return null;
        }
        return this.readUTF(this.text, 0, this.text.length);
    }

    public synchronized byte[] getPropertyBytes(String name) {
        return (byte[])this.getProperties().get(name);
    }

    public synchronized String getPropertyString(String name) {
        byte[] data = (byte[])this.getProperties().get(name);
        if (data == null) {
            return null;
        }
        if (data == NO_VALUE) {
            return "true";
        }
        return this.readUTF(data, 0, data.length);
    }

    public Enumeration getPropertyNames() {
        Hashtable props = this.getProperties();
        return props != null ? props.keys() : new Vector().elements();
    }

    void writeUTF(OutputStream out, String str) throws IOException {
        int i = 0;
        int len = str.length();
        while (i < len) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
            } else if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
            } else {
                out.write(0xC0 | c >> 6 & 0x1F);
                out.write(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
    }

    String readUTF(byte[] data, int off, int len) {
        StringBuffer buf = new StringBuffer();
        int end = off + len;
        while (off < end) {
            int ch = data[off++] & 0xFF;
            switch (ch >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    if (off >= len) {
                        return null;
                    }
                    ch = (ch & 0x1F) << 6 | data[off++] & 0x3F;
                    break;
                }
                case 14: {
                    if (off + 2 >= len) {
                        return null;
                    }
                    ch = (ch & 0xF) << 12 | (data[off++] & 0x3F) << 6 | data[off++] & 0x3F;
                    break;
                }
                default: {
                    if (off + 1 >= len) {
                        return null;
                    }
                    ch = (ch & 0x3F) << 4 | data[off++] & 0xF;
                }
            }
            buf.append((char)ch);
        }
        return buf.toString();
    }

    synchronized Hashtable getProperties() {
        if (this.props == null && this.text != null) {
            this.props = new Hashtable();
            int off = 0;
            while (off < this.text.length) {
                int len;
                if ((len = this.text[off++] & 0xFF) == 0 || off + len > this.text.length) {
                    this.props.clear();
                    break;
                }
                int i = 0;
                while (i < len && this.text[off + i] != 61) {
                    ++i;
                }
                String name = this.readUTF(this.text, off, i);
                if (name == null) {
                    this.props.clear();
                    break;
                }
                if (i == len) {
                    this.props.put(name, NO_VALUE);
                    continue;
                }
                byte[] value = new byte[len - i];
                System.arraycopy(this.text, off + i + 1, value, 0, len - i - 1);
                this.props.put(name, value);
                off += len;
            }
        }
        return this.props;
    }

    int getIPAddress() {
        byte[] data = this.addr.getAddress();
        return (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }

    void updateRecord(Rendezvous rendezvous, long now, DNSRecord rec) {
        if (rec != null && !rec.isExpired(now)) {
            switch (rec.type) {
                case 1: {
                    if (!rec.name.equals(this.server)) break;
                    this.addr = ((DNSRecord.Address)rec).getAddress();
                    break;
                }
                case 33: {
                    if (!rec.name.equals(this.name)) break;
                    DNSRecord.Service srv = (DNSRecord.Service)rec;
                    this.server = srv.server;
                    this.port = srv.port;
                    this.weight = srv.weight;
                    this.priority = srv.priority;
                    this.addr = null;
                    this.updateRecord(rendezvous, now, (DNSRecord)rendezvous.cache.get(this.server, 1, 1));
                    break;
                }
                case 16: {
                    if (!rec.name.equals(this.name)) break;
                    DNSRecord.Text txt = (DNSRecord.Text)rec;
                    this.text = txt.text;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean request(Rendezvous rendezvous, long timeout) {
        long now = System.currentTimeMillis();
        int delay = 200;
        long next = now + (long)delay;
        long last = now + timeout;
        try {
            try {
                rendezvous.addListener(this, new DNSQuestion(this.name, 255, 1));
                while (true) {
                    DNSConstants out;
                    if (this.server != null && this.addr != null && this.text != null) {
                        break;
                    }
                    if (last <= now) {
                        Object var12_10 = null;
                        rendezvous.removeListener(this);
                        return false;
                    }
                    if (next <= now) {
                        out = new DNSOutgoing(0);
                        ((DNSOutgoing)out).addQuestion(new DNSQuestion(this.name, 33, 1));
                        ((DNSOutgoing)out).addQuestion(new DNSQuestion(this.name, 16, 1));
                        if (this.server != null) {
                            ((DNSOutgoing)out).addQuestion(new DNSQuestion(this.server, 1, 1));
                        }
                        ((DNSOutgoing)out).addAnswer((DNSRecord)rendezvous.cache.get(this.name, 33, 1), now);
                        ((DNSOutgoing)out).addAnswer((DNSRecord)rendezvous.cache.get(this.name, 16, 1), now);
                        if (this.server != null) {
                            ((DNSOutgoing)out).addAnswer((DNSRecord)rendezvous.cache.get(this.server, 1, 1), now);
                        }
                        rendezvous.send((DNSOutgoing)out);
                        next = now + (long)delay;
                        delay *= 2;
                    }
                    out = rendezvous;
                    synchronized (out) {
                        rendezvous.wait(Math.min(next, last) - now);
                    }
                    now = System.currentTimeMillis();
                }
            }
            catch (IOException e) {
                Object var12_12 = null;
                rendezvous.removeListener(this);
                return false;
            }
            catch (InterruptedException e) {
                Object var12_13 = null;
                rendezvous.removeListener(this);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            rendezvous.removeListener(this);
            throw throwable;
        }
        Object var12_11 = null;
        rendezvous.removeListener(this);
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceInfo && this.name.equals(((ServiceInfo)obj).name);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("service[");
        buf.append(this.name);
        buf.append(',');
        buf.append(this.getAddress());
        buf.append(':');
        buf.append(this.port);
        buf.append(',');
        buf.append(this.text.length < 20 ? new String(this.text) : String.valueOf(new String(this.text, 0, 17)) + "...");
        buf.append(']');
        return buf.toString();
    }
}

