/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.util.logging.Logger;

class DNSEntry {
    private static Logger logger;
    String key;
    String name;
    int type;
    int clazz;
    boolean unique;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.jmdns.DNSEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.toString());
    }

    DNSEntry(String name, int type, int clazz) {
        this.key = name.toLowerCase();
        this.name = name;
        this.type = type;
        this.clazz = clazz & Short.MAX_VALUE;
        this.unique = (clazz & 0x8000) != 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DNSEntry) {
            DNSEntry other = (DNSEntry)obj;
            return this.name.equals(other.name) && this.type == other.type && this.clazz == other.clazz;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode() + this.type + this.clazz;
    }

    static String getClazz(int clazz) {
        switch (clazz & Short.MAX_VALUE) {
            case 1: {
                return "in";
            }
            case 2: {
                return "cs";
            }
            case 3: {
                return "ch";
            }
            case 4: {
                return "hs";
            }
            case 254: {
                return "none";
            }
            case 255: {
                return "any";
            }
        }
        return "?";
    }

    static String getType(int type) {
        switch (type) {
            case 1: {
                return "a";
            }
            case 28: {
                return "aaaa";
            }
            case 2: {
                return "ns";
            }
            case 3: {
                return "md";
            }
            case 4: {
                return "mf";
            }
            case 5: {
                return "cname";
            }
            case 6: {
                return "soa";
            }
            case 7: {
                return "mb";
            }
            case 8: {
                return "mg";
            }
            case 9: {
                return "mr";
            }
            case 10: {
                return "null";
            }
            case 11: {
                return "wks";
            }
            case 12: {
                return "ptr";
            }
            case 13: {
                return "hinfo";
            }
            case 14: {
                return "minfo";
            }
            case 15: {
                return "mx";
            }
            case 16: {
                return "txt";
            }
            case 33: {
                return "srv";
            }
            case 255: {
                return "any";
            }
        }
        return "?";
    }

    public String toString(String hdr, String other) {
        return String.valueOf(hdr) + "[" + DNSEntry.getType(this.type) + "," + DNSEntry.getClazz(this.clazz) + (this.unique ? "-unique," : ",") + this.name + (other != null ? "," + other + "]" : "]");
    }
}

