/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.util.ArrayList;
import java.util.logging.Logger;

public class DNSState
implements Comparable {
    private static Logger logger;
    private final String name;
    private static int nextOrdinal;
    private final int ordinal = nextOrdinal++;
    private static final ArrayList sequence;
    public static final DNSState PROBING_1;
    public static final DNSState PROBING_2;
    public static final DNSState PROBING_3;
    public static final DNSState ANNOUNCING_1;
    public static final DNSState ANNOUNCING_2;
    public static final DNSState ANNOUNCED;
    public static final DNSState CANCELED;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.jmdns.DNSState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.toString());
        nextOrdinal = 0;
        sequence = new ArrayList();
        PROBING_1 = new DNSState("probing 1");
        PROBING_2 = new DNSState("probing 2");
        PROBING_3 = new DNSState("probing 3");
        ANNOUNCING_1 = new DNSState("announcing 1");
        ANNOUNCING_2 = new DNSState("announcing 2");
        ANNOUNCED = new DNSState("announced");
        CANCELED = new DNSState("canceled");
    }

    private DNSState(String name) {
        this.name = name;
        sequence.add(this);
    }

    public final String toString() {
        return this.name;
    }

    public final DNSState advance() {
        return this.isProbing() || this.isAnnouncing() ? (DNSState)sequence.get(this.ordinal + 1) : this;
    }

    public final DNSState revert() {
        return this == CANCELED ? this : PROBING_1;
    }

    public boolean isProbing() {
        return this.compareTo(PROBING_1) >= 0 && this.compareTo(PROBING_3) <= 0;
    }

    public boolean isAnnouncing() {
        return this.compareTo(ANNOUNCING_1) >= 0 && this.compareTo(ANNOUNCING_2) <= 0;
    }

    public boolean isAnnounced() {
        return this.compareTo(ANNOUNCED) == 0;
    }

    public int compareTo(Object o) {
        return this.ordinal - ((DNSState)o).ordinal;
    }
}

