/*
 * Decompiled with CFR 0.152.
 */
package nfjs.jmdns;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import nfjs.jmdns.ZeroConfServiceLocator;

public class LocalHttpBrowser
implements ServiceListener {
    private JList navigationList;
    private JEditorPane displayPane;
    private JLabel statusLabel;
    private ZeroConfServiceLocator zcsl = new ZeroConfServiceLocator();
    private Set services;

    LocalHttpBrowser() {
        this.zcsl.searchForService("_http._tcp.local.", this);
        this.services = new HashSet();
    }

    protected JFrame buildBrowser(String url) {
        JFrame jf = new JFrame(url);
        JPanel panel = new JPanel(new BorderLayout());
        try {
            JEditorPane displayPane = new JEditorPane(url);
            JScrollPane jsp = new JScrollPane(displayPane);
            displayPane.setEditable(false);
            panel.add((Component)jsp, "Center");
            jf.getContentPane().add(panel);
            jf.pack();
            jf.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jf;
    }

    public static void main(String[] args) {
        LocalHttpBrowser lhb = new LocalHttpBrowser();
        JFrame jf = new JFrame("Local Http Browser");
        jf.setLocation(200, 200);
        jf.getContentPane().add(new JLabel("Searching for local Http servers..."));
        jf.addWindowListener(lhb.new BrowserWindowAdapter());
        jf.pack();
        jf.show();
    }

    public void serviceTypeAdded(ServiceEvent event) {
        System.out.println("EVENT: " + event);
    }

    public void serviceAdded(ServiceEvent event) {
        System.out.println("HELLO");
    }

    public void serviceRemoved(ServiceEvent event) {
    }

    public void serviceResolved(ServiceEvent event) {
        System.out.println("RESOLVED");
        ServiceInfo si = event.getInfo();
        System.out.println("Adding!!!");
        if (si.getHostAddress().indexOf(":") != -1) {
            return;
        }
        String url = "http://" + si.getHostAddress() + ":" + si.getPort() + si.getPropertyString("path");
        if (this.services.contains(url)) {
            return;
        }
        System.out.println("Adding: " + url);
        this.services.add(url);
        this.buildBrowser(url);
    }

    class BrowserWindowAdapter
    extends WindowAdapter {
        BrowserWindowAdapter() {
        }

        public void windowClosing(WindowEvent arg0) {
            LocalHttpBrowser.this.zcsl.shutdown();
            System.exit(0);
        }
    }

    class HttpServiceListModel
    implements ListModel {
        private List serviceList = new ArrayList();

        HttpServiceListModel() {
        }

        public int getSize() {
            return this.serviceList.size();
        }

        public Object getElementAt(int arg0) {
            ServiceInfo si = (ServiceInfo)this.serviceList.get(arg0);
            return si.getNiceTextString();
        }

        public void addService(ServiceInfo si) {
            if (!this.serviceList.contains(si)) {
                this.serviceList.add(si);
            }
        }

        public void addListDataListener(ListDataListener arg0) {
        }

        public void removeListDataListener(ListDataListener arg0) {
        }
    }
}

