/*
 * Decompiled with CFR 0.152.
 */
package nfjs.jmdns;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.session.SessionChannelClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;

public class SSHTest {
    public static void main(String[] args) {
        try {
            JmDNS jmdns = new JmDNS();
            HashSet<ServiceInfo> serviceSet = new HashSet<ServiceInfo>();
            boolean done = false;
            int count = 0;
            while (!done) {
                ServiceInfo[] infos = jmdns.list("_ssh._tcp.local.");
                int i = 0;
                while (i < infos.length) {
                    System.out.println("infos:" + infos[i]);
                    serviceSet.add(infos[i]);
                    ++i;
                }
                System.out.print(".");
                if (++count == 100) {
                    count = 0;
                    System.out.println("");
                }
                Thread.sleep(100L);
                if (serviceSet.size() <= 0) continue;
                done = true;
                System.out.println("\nFound:");
            }
            Iterator itor = serviceSet.iterator();
            ServiceInfo si = null;
            String host = null;
            while (itor.hasNext()) {
                si = (ServiceInfo)itor.next();
                System.out.println("SI: " + si.getName());
                if (si.getName().equals("Harpua")) {
                    host = si.getHostAddress();
                }
                System.out.println("Service: " + si);
            }
            ConfigurationLoader.initialize((boolean)false);
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            SshClient ssh = new SshClient();
            ssh.setSocketTimeout(30000);
            SshConnectionProperties properties = new SshConnectionProperties();
            properties.setHost(host);
            properties.setPrefPublicKey("ssh-dss");
            ssh.connect(properties);
            PasswordAuthenticationClient pwd = new PasswordAuthenticationClient();
            System.out.print("Username: ");
            String username = reader.readLine();
            pwd.setUsername(username);
            System.out.print("Password: ");
            String password = reader.readLine();
            pwd.setPassword(password);
            int result = ssh.authenticate((SshAuthenticationClient)pwd);
            if (result == 4) {
                SessionChannelClient session = ssh.openSessionChannel();
                if (!session.requestPseudoTerminal("vt100", 80, 24, 0, 0, "")) {
                    System.out.println("Failed to allocate a pseudo terminal");
                }
                if (session.startShell()) {
                    IOStreamConnector input = new IOStreamConnector();
                    IOStreamConnector output = new IOStreamConnector();
                    IOStreamConnector error = new IOStreamConnector();
                    output.setCloseOutput(false);
                    input.setCloseInput(false);
                    error.setCloseOutput(false);
                    input.connect(System.in, (OutputStream)session.getOutputStream());
                    output.connect((InputStream)session.getInputStream(), (OutputStream)System.out);
                    error.connect(session.getStderrInputStream(), (OutputStream)System.out);
                    session.getState().waitForState(3);
                } else {
                    System.out.println("Failed to start the user's shell");
                }
                ssh.disconnect();
            } else {
                System.out.println("RESULT: " + result);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

