/*
 * Decompiled with CFR 0.152.
 */
package org.rdfweb.foafcon;

import com.strangeberry.rendezvous.ServiceInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.rdfweb.foafcon.Person;
import org.rdfweb.foafcon.RendTest;
import org.rdfweb.foafcon.Util;

public class CommandLine {
    RendTest controller;

    public CommandLine(RendTest controller) {
        this.controller = controller;
    }

    public void run() {
        InputStreamReader reader = new InputStreamReader(System.in);
        BufferedReader inputReader = new BufferedReader(reader);
        String input = null;
        StreamTokenizer inputTokeniser = null;
        while (true) {
            try {
                System.out.print("% ");
                input = inputReader.readLine();
                inputTokeniser = new StreamTokenizer(new StringReader(input));
                inputTokeniser.wordChars(33, 126);
                int returned = inputTokeniser.nextToken();
                if (returned == 10 || returned == -1) continue;
                if (returned == -2) {
                    this.unrecognised();
                    continue;
                }
                String command = inputTokeniser.sval.toLowerCase();
                if (command.equals("find")) {
                    this.find(inputTokeniser);
                    continue;
                }
                if (command.equals("show")) {
                    this.show(inputTokeniser);
                    continue;
                }
                if (command.equals("iknow")) {
                    this.iknow(inputTokeniser);
                    continue;
                }
                if (command.equals("dump")) {
                    this.dump(inputTokeniser);
                    continue;
                }
                if (command.equals("exit")) {
                    this.exit();
                    continue;
                }
                if (command.equals("set")) {
                    this.set(inputTokeniser);
                    continue;
                }
                if (command.equals("help") || command.equals("?")) {
                    this.help();
                    continue;
                }
                this.unrecognised();
                continue;
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
                continue;
            }
            break;
        }
    }

    public void find(StreamTokenizer it) throws Exception {
        this.controller.findPeople();
        List people = this.controller.getPeople();
        int n = 1;
        System.out.println("\tName\t\tHomepage\t\tInterest");
        Iterator i = people.iterator();
        while (i.hasNext()) {
            ServiceInfo info = (ServiceInfo)i.next();
            System.out.print("[" + n + "]\t");
            String name = info.getPropertyString("n");
            String homepage = info.getPropertyString("h");
            String interest = info.getPropertyString("i");
            String seeAlso = info.getPropertyString("s");
            System.out.print(String.valueOf(info.getPropertyString("n")) + "\t");
            if (homepage != null) {
                System.out.print(String.valueOf(info.getPropertyString("h")) + "\t");
            } else {
                System.out.print("---\t\t");
            }
            if (interest != null) {
                System.out.print(info.getPropertyString("i"));
            } else {
                System.out.print("---");
            }
            System.out.print("\n");
            ++n;
        }
    }

    public void show(StreamTokenizer it) throws Exception {
        List people = this.controller.getPeople();
        if (people == null) {
            throw new Exception("Noone found yet: try 'find' first.");
        }
        int tt;
        while ((tt = it.nextToken()) != -1 && tt != 10) {
            if (tt == -3) {
                throw new Exception("Usage: show <number>");
            }
            int num = (int)it.nval;
            ServiceInfo info = (ServiceInfo)people.get(num - 1);
            String content = Util.get("http", info.getAddress(), info.getPort(), "/");
            System.out.println(content);
        }
        return;
    }

    public void iknow(StreamTokenizer it) throws Exception {
        List people = this.controller.getPeople();
        if (people == null) {
            throw new Exception("Noone found yet: try 'find' first.");
        }
        int tt;
        while ((tt = it.nextToken()) != -1 && tt != 10) {
            if (tt == -3) {
                throw new Exception("Usage: iknow <number>");
            }
            int num = (int)it.nval;
            ServiceInfo info = (ServiceInfo)people.get(num - 1);
            Person knownPerson = new Person(info.getPropertyString("n"), info.getName(), info.getPropertyString("h"), info.getPropertyString("i"), info.getPropertyString("s"));
            this.controller.getPerson().addKnows(knownPerson);
        }
        return;
    }

    public void dump(StreamTokenizer it) throws Exception {
        int tt = it.nextToken();
        if (tt != -3) {
            System.out.println(this.controller.getPerson().toRDF());
        } else {
            String filename = it.sval;
            Util.toFile(filename, this.controller.getPerson().toRDF());
            System.out.println("Information saved to " + filename);
        }
    }

    public void exit() {
        System.exit(0);
    }

    public void unrecognised() throws Exception {
        throw new Exception("Unrecognised command");
    }

    public void set(StreamTokenizer it) throws Exception {
        int tt = it.nextToken();
        if (tt != -3) {
            throw new Exception("Usage: set <var>");
        }
        String var = it.sval.toLowerCase();
        String val = null;
        if (!var.equals("plan")) {
            tt = it.nextToken();
            if (tt != -3) {
                throw new Exception("Usage: set " + var + " <val>");
            }
            val = it.sval;
            if (val.equals("\"\"")) {
                val = null;
            }
        }
        Person person = this.controller.getPerson();
        if (var.equals("name")) {
            if (val == null) {
                throw new Exception("Name cannot be empty");
            }
            person.setName(val);
            this.controller.kickService();
        } else if (var.equals("homepage")) {
            person.setHomepage(val);
            this.controller.kickService();
        } else if (var.equals("seealso")) {
            person.setSeeAlso(val);
            this.controller.kickService();
        } else if (var.equals("interest")) {
            person.setInterest(val);
            this.controller.kickService();
        } else if (var.equals("plan")) {
            person.setPlan(this.getMultiInput());
        } else if (var.equals("showmbox")) {
            person.setShowMbox((val = val.toLowerCase()).equals("true") || val.equals("yes"));
        } else {
            throw new Exception("Unknown variable: " + var);
        }
    }

    private String getMultiInput() throws Exception {
        StringBuffer sb = new StringBuffer();
        System.out.println("(Enter text, and finish with two blank lines)");
        InputStreamReader reader = new InputStreamReader(System.in);
        BufferedReader inputReader = new BufferedReader(reader);
        boolean lastLineEmpty = false;
        while (true) {
            String input;
            if ((input = inputReader.readLine()).equals("")) {
                if (lastLineEmpty) break;
                lastLineEmpty = true;
            } else {
                lastLineEmpty = false;
            }
            sb.append(input);
            sb.append("\n");
        }
        sb.deleteCharAt(sb.length() - 1);
        String toReturn = sb.toString();
        if (toReturn.equals("")) {
            return null;
        }
        return toReturn;
    }

    public void help() {
        System.out.println("Commands:\n\nhelp -- well, you found it :-)\nfind -- show people on the local network.\nshow <number> [<number>...] -- show detailed information on person (people).\niknow <number> [<number>...] -- indicate that you know person (people)\nset <var> <val> -- set information. If <val> is \"\" unsets <var>.\n\t<var> can be:\n\tname -- your name (can't be unset)\n\thomepage -- your homepage [URL]\n\tinterest -- a URL indicating an interest, eg http://rdfweb.org/foaf/.\n\tseealso -- more information about you in rdf (eg output of \"dump\") [URL]\n\tshowmbox -- by default your email address is private. Using \"true\"\n\t\tor \"yes\" means people can see it (other values mean they can't).\n\tplan -- No value needed as you'll enter a simple editor.\n\t\tPlan is like the old unix .plan file. Let people know what you're\n\t\tup to, and maybe where you are (eg on IRC). Dumping ground :-)\ndump <filename> -- produces RDF/XML serialised form of information about you,\n\tsaving it to <filename>. Without a filename shows you RDF/XML.\nexit -- exit\n");
    }
}

