/*
 * Decompiled with CFR 0.152.
 */
package org.rdfweb.foafcon;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.StringTokenizer;
import org.rdfweb.foafcon.HTTPRequestHandler;

class HttpConnectionHandler
implements Runnable {
    static final String CRLF = "\r\n";
    Socket socket;
    InputStream input;
    OutputStream output;
    BufferedReader br;
    HTTPRequestHandler reqHandler;

    public HttpConnectionHandler(Socket socket, HTTPRequestHandler reqHandler) throws Exception {
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.reqHandler = reqHandler;
    }

    public void run() {
        try {
            this.processRequest();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void processRequest() throws Exception {
        String headerLine;
        while (!(headerLine = this.br.readLine()).equals(CRLF) && !headerLine.equals("")) {
            StringTokenizer s = new StringTokenizer(headerLine);
            String temp = s.nextToken();
            if (!temp.equals("GET")) continue;
            String object = s.nextToken();
            String serverLine = "Server: fpont simple java httpServer";
            String statusLine = null;
            String contentTypeLine = null;
            String contentLengthLine = "error";
            String content = this.reqHandler.get(object);
            if (content != null) {
                statusLine = "HTTP/1.0 200 OK\r\n";
                contentTypeLine = "Content-type: " + this.reqHandler.contentType(object) + CRLF;
                contentLengthLine = "Content-Length: " + content.length() + CRLF;
            } else {
                statusLine = "HTTP/1.0 404 Not Found\r\n";
                contentTypeLine = "text/html";
                content = "<HTML><HEAD><TITLE>404 Not Found</TITLE></HEAD><BODY>404 Not Found<br>usage:http://yourHostName:port/fileName.html</BODY></HTML>";
            }
            this.output.write(statusLine.getBytes());
            this.output.write(serverLine.getBytes());
            this.output.write(contentTypeLine.getBytes());
            this.output.write(contentLengthLine.getBytes());
            this.output.write(CRLF.getBytes());
            this.output.write(content.getBytes());
        }
        try {
            this.output.close();
            this.br.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

