/*
 * Decompiled with CFR 0.152.
 */
package org.rdfweb.foafcon;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.rdfweb.foafcon.HTTPRequestHandler;
import org.rdfweb.foafcon.HttpConnectionHandler;

public class HttpServer
implements Runnable {
    int port;
    HTTPRequestHandler reqHandler;
    Thread listenThread;

    public HttpServer(int port, HTTPRequestHandler reqHandler) {
        this.port = port;
        this.reqHandler = reqHandler;
    }

    public void start() {
        this.listenThread = new Thread(this);
        this.listenThread.start();
    }

    public void run() {
        try {
            ServerSocket socket = new ServerSocket(this.port);
            System.out.println("httpServer running on port " + socket.getLocalPort());
            while (true) {
                Socket requestSocket = socket.accept();
                try {
                    HttpConnectionHandler request = new HttpConnectionHandler(requestSocket, this.reqHandler);
                    Thread thread = new Thread(request);
                    thread.start();
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
        catch (IOException e) {
            System.out.println(e);
            return;
        }
    }
}

