/*
 * Decompiled with CFR 0.152.
 */
package org.rdfweb.foafcon;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.rdfweb.foafcon.Util;

public class Person {
    static final String NAME = "n";
    static final String HOMEPAGE = "h";
    static final String INTEREST = "i";
    static final String SEEALSO = "s";
    String name;
    String mbox;
    String mboxHash;
    String plan;
    String homepage;
    String interest;
    String seeAlso;
    boolean showMbox = false;
    ArrayList knows;

    public Person(String name, String mbox) {
        this.setName(name);
        this.setMbox(mbox);
        this.knows = new ArrayList();
    }

    public Person(String name, String mboxHash, String homepage, String interest, String seeAlso) {
        this.setName(name);
        this.setMboxHash(mboxHash);
        this.setHomepage(homepage);
        this.setInterest(interest);
        this.setSeeAlso(seeAlso);
        this.knows = new ArrayList();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setMbox(String mbox) {
        this.mbox = mbox;
        this.setMboxHash(Person.sha1Hash(mbox));
    }

    public String getMbox() {
        return this.mbox;
    }

    public void setMboxHash(String mboxHash) {
        this.mboxHash = mboxHash;
    }

    public String getMboxHash() {
        return this.mboxHash;
    }

    public void setShowMbox(boolean showMbox) {
        this.showMbox = showMbox;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setSeeAlso(String seeAlso) {
        this.seeAlso = seeAlso;
    }

    public String getSeeAlso() {
        return this.seeAlso;
    }

    public void setInterest(String interest) {
        this.interest = interest;
    }

    public String getInterest() {
        return this.interest;
    }

    public void setPlan(String plan) {
        this.plan = plan;
    }

    public String getPlan() {
        return this.plan;
    }

    public synchronized void addKnows(Person person) {
        this.knows.add(person);
    }

    public Hashtable getProps() {
        Hashtable<String, String> toReturn = new Hashtable<String, String>();
        toReturn.put(NAME, this.getName());
        if (this.getHomepage() != null) {
            toReturn.put(HOMEPAGE, this.getHomepage());
        }
        if (this.getInterest() != null) {
            toReturn.put(INTEREST, this.getInterest());
        }
        if (this.getSeeAlso() != null) {
            toReturn.put(SEEALSO, this.getSeeAlso());
        }
        return toReturn;
    }

    public String toString() {
        return this.toString("");
    }

    public synchronized String toString(String indent) {
        String toReturn = String.valueOf(indent) + "Name: " + this.name + "\n" + indent + "Hash Mbox: " + this.mboxHash + "\n";
        if (this.showMbox && this.mbox != null) {
            toReturn = String.valueOf(toReturn) + indent + "Mbox: " + this.mbox + "\n";
        }
        if (this.homepage != null) {
            toReturn = String.valueOf(toReturn) + indent + "Homepage: " + this.homepage + "\n";
        }
        if (this.interest != null) {
            toReturn = String.valueOf(toReturn) + indent + "Interest: " + this.interest + "\n";
        }
        if (this.seeAlso != null) {
            toReturn = String.valueOf(toReturn) + indent + "See Also: " + this.seeAlso + "\n";
        }
        if (this.plan != null) {
            toReturn = String.valueOf(toReturn) + indent + "Plan: " + this.plan + "\n";
        }
        Iterator i = this.knows.iterator();
        while (i.hasNext()) {
            Person person = (Person)i.next();
            toReturn = String.valueOf(toReturn) + indent + "Knows:\n";
            toReturn = String.valueOf(toReturn) + person.toString("\t");
        }
        return toReturn;
    }

    public String toRDF() {
        String toReturn = "<?xml version=\"1.0\"?>\n";
        toReturn = String.valueOf(toReturn) + "<rdf:RDF xmlns=\"http://xmlns.com/foaf/0.1/\"\n";
        toReturn = String.valueOf(toReturn) + "         xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n";
        toReturn = String.valueOf(toReturn) + "         xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"\n";
        toReturn = String.valueOf(toReturn) + ">\n\n";
        toReturn = String.valueOf(toReturn) + this.toRDF("    ", "");
        toReturn = String.valueOf(toReturn) + "</rdf:RDF>";
        return toReturn;
    }

    public String toRDF(String indent, String totalIndent) {
        String toReturn = String.valueOf(totalIndent) + "<Person>\n";
        toReturn = String.valueOf(toReturn) + totalIndent + indent + "<name>" + Util.escape(this.name) + "</name>\n";
        toReturn = String.valueOf(toReturn) + totalIndent + indent + "<mbox_sha1sum>" + Util.escape(this.mboxHash) + "</mbox_sha1sum>\n";
        if (this.showMbox && this.mbox != null) {
            toReturn = String.valueOf(toReturn) + totalIndent + indent + "<mbox rdf:resource=\"mailto:" + Util.escape(this.mbox) + "\"/>\n";
        }
        if (this.interest != null) {
            toReturn = String.valueOf(toReturn) + totalIndent + indent + "<interest rdf:resource=\"" + Util.escape(this.interest) + "\"/>\n";
        }
        if (this.homepage != null) {
            toReturn = String.valueOf(toReturn) + totalIndent + indent + "<homepage rdf:resource=\"" + Util.escape(this.homepage) + "\"/>\n";
        }
        if (this.seeAlso != null) {
            toReturn = String.valueOf(toReturn) + totalIndent + indent + "<rdfs:seeAlso rdf:resource=\"" + Util.escape(this.seeAlso) + "\"/>\n";
        }
        if (this.plan != null) {
            toReturn = String.valueOf(toReturn) + totalIndent + indent + "<plan>" + Util.escape(this.plan) + "</plan>\n";
        }
        Iterator i = this.knows.iterator();
        while (i.hasNext()) {
            Person person = (Person)i.next();
            toReturn = String.valueOf(toReturn) + totalIndent + indent + "<knows>\n";
            toReturn = String.valueOf(toReturn) + person.toRDF(indent, String.valueOf(totalIndent) + indent);
            toReturn = String.valueOf(toReturn) + totalIndent + indent + "</knows>\n";
        }
        toReturn = String.valueOf(toReturn) + totalIndent + "</Person>\n";
        return toReturn;
    }

    private static String sha1Hash(String string) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(string.getBytes());
            byte[] digest = md.digest();
            BigInteger integer = new BigInteger(1, digest);
            return integer.toString(16);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Person)) {
            return false;
        }
        return this.mboxHash.equals(((Person)obj).getMboxHash());
    }
}

