/*
 * Decompiled with CFR 0.152.
 */
package org.rdfweb.foafcon;

import com.strangeberry.rendezvous.Rendezvous;
import com.strangeberry.rendezvous.ServiceInfo;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.List;
import org.rdfweb.foafcon.CommandLine;
import org.rdfweb.foafcon.HTTPTestHandler;
import org.rdfweb.foafcon.HttpServer;
import org.rdfweb.foafcon.Person;
import org.rdfweb.foafcon.TestListener;

public class RendTest {
    static final String type = "_foafcon._tcp.local.";
    List people;
    Person person;
    int port = 7654;
    TestListener listener;
    Rendezvous rv;
    InetAddress inetaddr;
    ServiceInfo si;

    public static void main(String[] args) {
        RendTest rt = new RendTest(args);
        rt.start();
        CommandLine cl = new CommandLine(rt);
        cl.run();
    }

    public RendTest(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: RendTest <name> <mailbox> [<port>]");
            System.exit(1);
        }
        this.person = new Person(args[0], args[1]);
        if (args.length > 2) {
            try {
                this.port = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                System.err.println("Port must be an integer.");
                System.exit(1);
            }
        }
    }

    public void start() {
        Hashtable props = this.person.getProps();
        String hashBox = this.person.getMboxHash();
        this.listener = new TestListener();
        try {
            this.rv = new Rendezvous();
            this.inetaddr = InetAddress.getLocalHost();
            System.out.println("Binding to: " + this.inetaddr);
            this.si = new ServiceInfo(type, String.valueOf(hashBox) + "." + type, this.inetaddr, this.port, 0, 0, props);
            this.rv.registerService(this.si);
            this.rv.addServiceListener(type, this.listener);
            HttpServer httpServer = new HttpServer(this.port, new HTTPTestHandler(this.person));
            httpServer.start();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    public void kickService() throws Exception {
        this.rv.unregisterService(this.si);
        Hashtable props = this.person.getProps();
        String hashBox = this.person.getMboxHash();
        this.si = new ServiceInfo(type, String.valueOf(hashBox) + "." + type, this.inetaddr, this.port, 0, 0, props);
        this.rv.registerService(this.si);
    }

    public void findPeople() {
        this.people = this.listener.getPeople();
    }

    public List getPeople() {
        return this.people;
    }

    public Person getPerson() {
        return this.person;
    }
}

