// %Z%%M%, %I%, %G%
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package nfjs.jmdns;

import java.io.IOException;

import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceTypeListener;

/**
 * Sample Code for Listing Services using JmDNS.
 * <p>
 * Run the main method of this class. This class prints a list of available HTTP
 * services every 5 seconds.
 *
 * @author  Werner Randelshofer
 * @version 	%I%, %G%
 */
public class ListServices implements ServiceTypeListener
{
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        
        try {
			ListServices ls = new ListServices();
			
			String serviceType = null;
			
			if( args.length == 1 ) {
				serviceType = args[ 0 ];
			} else {
				serviceType = "_http._tcp.local.";
				//serviceType = "_services._dns-sd._udp.local.";
			}
			
			JmDNS jmdns = new JmDNS();
			jmdns.addServiceTypeListener( ls );
			while (true) {
				ServiceInfo[] infos = jmdns.list( serviceType );
				
				try {
					for( int i = 0; i < infos.length; i++ ) {
						System.out.println("SERVICE: " + infos[ i ] );
					}
					Thread.sleep(2000);
				} catch (InterruptedException e) {
					break;
				}
			}
        } catch (IOException e) {
        	e.printStackTrace();
        }
    }

	public void serviceTypeAdded(ServiceEvent event) {
		System.out.println("New Service: " + event );
		
	}
}
