package nfjs.jmdns;

import java.net.InetAddress;

import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;

import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.ResourceHandler;

/*
 * This is a simple example to show registering a service. We chose
 * to start up an embedded Jetty instance listening on a particular
 * port. If the user specifies a port on the command line, we'll 
 * try to go with that.
 *  
 */

public class RegisterService {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		try {
			
			int port = 32005;
			
			if( args.length > 0 ) {
				port = Integer.valueOf( args[ 0 ] ).intValue();
			}
					
			JmDNS jmDNS = new JmDNS();//new JmDNS(InetAddress.getByName("Harpua.local.") );
			// Right now we are embedding the byte length in the parameter because of a
			// but in the JmDNS implementation. That shouldn't normally be necessary.
			
			ServiceInfo si = new ServiceInfo("_http._tcp.local.", "nfjs", port, "\025path=/nfjs/index.html" );
			jmDNS.registerService( si );
			
			HttpServer hs = new HttpServer();
			SocketListener listener = new SocketListener();
			listener.setPort( port );
			hs.addListener( listener );
			
			HttpContext context = new HttpContext();
			context.setContextPath( "/nfjs/*" );
			hs.addContext( context );
			context.setResourceBase( "./nfjs" );
			context.addHandler( new ResourceHandler() );
			
			hs.start();
			
			for( int i = 0; i < 1000; i++ ) {
				Thread.sleep( 1000 );
			}
			
			
		} catch( Exception e ) {
			e.printStackTrace();
		}
	}

}
