package nfjs.jmdns;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolState;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.io.IOStreamConnector;
import com.sshtools.j2ssh.session.SessionChannelClient;

public class SSHTest {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			JmDNS jmdns = new JmDNS();
			Set serviceSet = new HashSet();
			
			boolean done = false;
			int count = 0;
			
			while( !done ) {
				ServiceInfo [] infos = jmdns.list("_ssh._tcp.local.");
				for( int i = 0; i < infos.length; i++ ) {
					System.out.println( "infos:" + infos[ i ] );
					serviceSet.add( infos[ i ] );
				}

				System.out.print(".");
				
				if( ++count == 100 ) {
					count = 0;
					System.out.println("");
				}
				
				Thread.sleep( 100 );
				
				if( serviceSet.size() > 0 ) {
					done = true;
					System.out.println("\nFound:");
				}
			}
			
			Iterator itor = serviceSet.iterator();
			ServiceInfo si = null; 
			
			String host = null;
			
			while( itor.hasNext() ) {
				si = ( ServiceInfo ) itor.next();
				
				System.out.println("SI: " + si.getName() );
				
				if( si.getName().equals("Maze" ) ) {
					host = si.getHostAddress();
				}

				System.out.println("Service: " + si );
			}
			
			ConfigurationLoader.initialize( false );
			BufferedReader reader = 
				new BufferedReader( new InputStreamReader( System.in ) );
			
			SshClient ssh = new SshClient();
			ssh.setSocketTimeout( 30000 );
			SshConnectionProperties properties = new SshConnectionProperties();
			properties.setHost( host );
			properties.setPrefPublicKey("ssh-dss");
			ssh.connect( properties );
			
			PasswordAuthenticationClient pwd = new PasswordAuthenticationClient();
			
			System.out.print( "Username: " );
			String username = reader.readLine();
			pwd.setUsername( username );
			
			System.out.print("Password: " );
			String password = reader.readLine();
			pwd.setPassword( password );
			
			int result = ssh.authenticate( pwd );
			
			if( result == AuthenticationProtocolState.COMPLETE ) {
				SessionChannelClient session = ssh.openSessionChannel();
				
				if( !session.requestPseudoTerminal( "vt100", 80, 24, 0, 0, "" ) ) {
					System.out.println("Failed to allocate a pseudo terminal");
				}
				
				if( session.startShell() ) {
					IOStreamConnector input = new IOStreamConnector();
					IOStreamConnector output = new IOStreamConnector();
					IOStreamConnector error = new IOStreamConnector();
					
					output.setCloseOutput( false );
					input.setCloseInput( false );
					error.setCloseOutput( false );
					
					input.connect( System.in, session.getOutputStream() );
					output.connect( session.getInputStream(), System.out );
					error.connect( session.getStderrInputStream(), System.out );
					session.getState().waitForState(ChannelState.CHANNEL_CLOSED);				
				} else {
					System.out.println("Failed to start the user's shell");
				}
				
				ssh.disconnect();
			} else {
				System.out.println("RESULT: " + result );
			}
			
		} catch (IOException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

	}
}
