package nfjs.jmdns;

import java.io.IOException;

import javax.jmdns.JmDNS;
import javax.jmdns.ServiceListener;

public class ZeroConfServiceLocator {
	private JmDNS jmdns;
	
	public ZeroConfServiceLocator() {
		try {
			jmdns = new JmDNS();
			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void searchForService( String serviceInstance, ServiceListener listener ) {

		if( listener != null ) {
			
			// If you don't call list at least once, the JmDNS doesn't
			// seem to announce to the listeners.
			
			jmdns.list( serviceInstance );
			jmdns.addServiceListener( serviceInstance, listener );
		}
	}
	
	public void shutdown() {
		jmdns.unregisterAllServices();
	}
}
